$(function() {
    if ($(".pageNavigationContainer").length) {
        var lastId,
            anchorMenu = $(".pageNavigationContainer ul ul"),
            menuItems = anchorMenu.find("a"),
            scrollItems = menuItems.map(function () {
                var $el = $(this),
                    href = $el.attr('href'),
                    arr = href.split('#'),
                    cid = '#' + arr[1];

                var item = $(cid);
                if (item.length) {
                    return item;
                }
            });

        menuItems.html(function(index, text) {
            return text.replace("RIA", "<strong>RIA</strong>");
        });

        menuItems.click(function (e) {
            e.preventDefault();

            var $el = $(this),
                href = $el.attr('href'),
                arr = href.split('#'),
                cid = '#' + arr[1],
                offsetTop = href === "#" ? 0 : $(cid).offset().top + 1;

            $("html, body").stop().animate({
                scrollTop: offsetTop
            }, 1000);
        });

        $(window).resize(function () {
            var fromTop = $(this).scrollTop();
            // Get id of current scroll item
            var cur = scrollItems.map(function () {
                if ($(this).offset().top <= fromTop) return this;
            });

            // Get the id of the current element
            cur = cur[cur.length - 1];
            var id = cur && cur.length ? cur[0].id : "";
            if (lastId !== id) {
                lastId = id;
                // Set/remove active class
                if (id != '') {
                    menuItems.removeClass("active").parent().end().filter("[href$='#" + id + "']").addClass("active");
                }
            }
        }).resize();

        $(window).scroll(function () {
            var fromTop = $(this).scrollTop();
            // Get id of current scroll item
            var cur = scrollItems.map(function () {
                if ($(this).offset().top <= fromTop) return this;
            });

            // Get the id of the current element
            cur = cur[cur.length - 1];
            var id = cur && cur.length ? cur[0].id : "";
            if (lastId !== id) {
                lastId = id;
                // Set/remove active class
                if (id != '') {
                    menuItems.removeClass("active").parent().end().filter("[href$='#" + id + "']").addClass("active");
                }
            }
        });
    }
});