$(function() {
    var headerHeight = $("#pageHeader").outerHeight();

    var checkFixedHeader = function() {
        if (scrollPositionY > headerHeight) {
            $body.addClass('fixedHeader');
        } else {
            $body.removeClass('fixedHeader');
        }
    };

    var checkHeaderSkip = function() {
        var gapTop = 200,
            scrollTop = $window.scrollTop(),
            opacity = 1;

        if (scrollTop <= gapTop) {
            opacity = 1 - (scrollTop / gapTop);
        } else {
            opacity = 0;
        }

        $(".headerSkip").css('opacity', opacity);
    };

    var checkFixedSubnavigation = function() {
        if (scrollPositionY > (100 * vh - 0)) {
            $body.addClass('fixedSubnavigation');
        } else {
            $body.removeClass('fixedSubnavigation');
        }
    };

    //AOS.init();

    //$(".parallax").parallax();

    if (is.chrome() || is.android() || is.opera() || is.ie(8) || is.ie(9)) {
        loadScript('https://cdnjs.cloudflare.com/ajax/libs/Hyphenator/5.3.0/Hyphenator.min.js', function () {
            Hyphenator.run();
        });
    }

    if ($("#subNavigation:visible").length) {
        $body.addClass('hasSubnavigation');
    }

    var $contentTables = document.querySelectorAll('table.contenttable');
    Array.prototype.forEach.call($contentTables, function(el, i){
        var html = el.innerHTML;
        html = html.replace('<td>&nbsp;<ul>', '<td><ul>');
        el.innerHTML = html;
    });

    $(".headerSkip").click(function(e) {
        $("html, body").animate({ scrollTop: viewportHeight - headerHeight }, 500);
    });

    $("#iconNavigationTrigger").click(function(e) {
        $body.toggleClass('overflowHidden');
    });

    $("#bodyNavigationTrigger").click(function(e) {
        $body.removeClass('overflowHidden');
    });

    $("#openSearch").click(function(e) {
        $body.toggleClass('overflowHidden');
        $("#searchForm").addClassDelayed('animate', 500);
    });

    $("#closeSearch").click(function(e) {
        $body.removeClass('overflowHidden');
        $("#searchForm").removeClass('animate');
    });

    $(".subNavigationLabel").click(function(e) {
        var $el = $(this).parent().prev('.subNavigationTrigger');
        if ($el.is(':checked')) {
            e.preventDefault();
            $el.prop('checked', false);
        }
    });

    $(".pictureOpenLightbox").click(function(e) {
        var $el = $(this).next('.pictureLightbox');

        e.preventDefault();

        $el.addClass('show');
    });

    $(".pictureLightbox").click(function(e) {
        e.preventDefault();

        $(this).removeClass('show');
    });

    $document.on('click', '.accordionLabel', function(e) {
        var $el = $(this).closest('.accordionItem'),
            $trigger = $el.prev('.accordionTrigger');

        e.preventDefault();

        if ($trigger.is(':checked')) {
            $trigger.prop('checked', false);
        } else {
            $trigger.prop('checked', true);
            setTimeout(function() { scrollToElement($el, 500, 200); }, 300);
        }
    });

    $(".cec-form_formframework select").change(function() {
        var $el = $(this),
            value = $('option:selected', this).val();

        if (value == '') {
            $el.removeClass('selected');
        } else {
            $el.addClass('selected');
        }

        /*if ($("#fakuma2017-singleselect-1 option:eq(5)").is(':selected')) {
            $("#fakuma2017-singleselect-2 option:eq(7)").hide();
        } else {
            $("#fakuma2017-singleselect-2 option:eq(7)").show();
        }*/
    });

    $(".cec-form_formframework input[type='file']").change(function(e) {
        var $el = $(this),
            inputValue = e.target.value.split( '\\' ).pop(),
            $label = $el.closest('.form-group').find('label'),
            labelText = $label.text();

        if (inputValue != '') {
            $label.text(inputValue).addClass('active');
        } else {
            $label.text(labelText);
        }
    });

    $(".cec-text h1:not(.hyphenate), .cec-text h2:not(.hyphenate)").addClass('hyphenate');

    $(".cec-text table").wrap('<div class="table-scrollable"></div>');

    /*$(".pageNavigationContainer a").click(function(e) {
        e.preventDefault();

        var $el = $(this),
            href = $el.attr('href'),
            arr = href.split('#'),
            cid = '#' + arr[1];

        var offset = $(cid).offset();

        if(!offset){return;}

        $("html, body").stop().animate({scrollTop: offset.top}, 1000);
    });*/

    //checkFixedHeader();
    //checkHeaderSkip();
    //if (!$body.hasClass('customer')) checkFixedSubnavigation();

    $document.on('click', '.headerSkip', function(e) {
        e.preventDefault();
    });

    $window.resize(function() {
    });

    $window.scroll(function() {
        //checkFixedHeader();
        //checkHeaderSkip();
        //if (!$body.hasClass('customer')) checkFixedSubnavigation();
    });

    var hashString = $(location).attr('hash').slice(1),
        hashElement = document.getElementById(hashString);

    if (typeof(hashElement) != 'undefined' && hashElement != null) {
        //console.log(hashString);
        $("html, body").scrollTop(0);
    } else {
        if (hashString.substring(0, 1) == 'c') {
            hashString = 'cec-' + hashString.substring(1);
            hashElement = document.getElementById(hashString);

            if (typeof(hashElement) != 'undefined' && hashElement != null) {
                $("html, body").scrollTop(0);
            }
        }
    }

    $('a[href*=\\#]').on('click', function (e) {
        if (this.pathname === window.location.pathname){
            e.preventDefault();
            var hashLinkString = $(this).prop("hash");
            hashLinkString = 'cec-' + hashLinkString.substring(2);
            var hashLinkElement = document.getElementById(hashLinkString);

            if (typeof(hashLinkElement) != 'undefined' && hashLinkElement != null) {
                scrollToElement($("#" + hashLinkString), 500, 200);
            }
        }
    });

    $window.load(function() {
        if (is.chrome() || is.android() || is.opera() || is.ie(8) || is.ie(9)) {
            loadScript('https://cdnjs.cloudflare.com/ajax/libs/Hyphenator/5.3.0/Hyphenator.min.js', function () {
                Hyphenator.run();
            });
        }

        if (typeof(hashElement) != 'undefined' && hashElement != null) {
            scrollToElement($("#" + hashString), 500, 200);
        }
    });
});