/**
 * Using API https://ipgeolocation.io/
 * Free 50K requests per month
 *
 */

(function () {
    var ipgeolocationApiKey           = 'd7d2c190f4c2438a830435a8f8684ca9',
        ipgeolocationUrl              = 'https://api.ipgeolocation.io/ipgeo?apiKey=' + ipgeolocationApiKey,
        ipgeolocationCookiePrefix     = 'ipgeolocation',
        ipgeolocationCookieExpireDays = 1,
        ipgeolocationSuccess          = false,
        ipgeolocationData             = {},
        ipgeolocationGdpr             = true,
        ipgeolocationGdprCookieName   = 't3cookieconsent',
        ipgeolocationGdprCookieValue  = 'allow';

    if (typeof setCookie != 'function') {
        var setCookie = function(cname, cvalue, exdays, cpath) {
            var d = new Date(), path;
            d.setTime(d.getTime() + (exdays*24*60*60*1000));
            var expires = "expires="+ d.toUTCString();
            if (typeof cpath != 'undefined' && cpath != '') {
                path = ";path=" + cpath;
            } else {
                path = ";path=/";
            }
            document.cookie = cname + "=" + cvalue + ";" + expires + path;
        };
    }

    if (typeof getCookie != 'function') {
        var getCookie = function(cname) {
            var name = cname + "=";
            var decodedCookie = decodeURIComponent(document.cookie);
            var ca = decodedCookie.split(';');
            for(var i = 0; i <ca.length; i++) {
                var c = ca[i];
                while (c.charAt(0) == ' ') {
                    c = c.substring(1);
                }
                if (c.indexOf(name) == 0) {
                    return c.substring(name.length, c.length);
                }
            }
            return "";
        };
    }

    var loadIpgeolocation = function(url, callback) {
            var ipgeolocation = new XMLHttpRequest();
            ipgeolocation.onreadystatechange = function() {
                if (this.readyState == 4 && this.status == 200) {
                    ipgeolocationData = JSON.parse(this.responseText);
                    ipgeolocationSuccess = true;

                    if (typeof callback === 'function') {
                        callback(this.responseText);
                    }
                }
            };
            ipgeolocation.open('GET', url, true);
            ipgeolocation.send();
    };

    var setIpgeolocationCookies = function(responseText) {
        var continentCode = ipgeolocationData.continent_code,
            continentName = ipgeolocationData.continent_name,
            countryCode2  = ipgeolocationData.country_code2,
            countryCode3  = ipgeolocationData.country_code3,
            countryName   = ipgeolocationData.country_name,
            countryTld    = ipgeolocationData.country_tld,
            city          = ipgeolocationData.city,
            languages     = ipgeolocationData.languages.split(','),
            language      = languages[0];

        setCookie(ipgeolocationCookiePrefix, 'load', ipgeolocationCookieExpireDays);
        setCookie(ipgeolocationCookiePrefix + '_continent_code', continentCode);
        setCookie(ipgeolocationCookiePrefix + '_continent_name', continentName);
        setCookie(ipgeolocationCookiePrefix + '_country_code2', countryCode2);
        setCookie(ipgeolocationCookiePrefix + '_country_code3', countryCode3);
        setCookie(ipgeolocationCookiePrefix + '_country_name', countryName);
        setCookie(ipgeolocationCookiePrefix + '_country_tld', countryTld);
        setCookie(ipgeolocationCookiePrefix + '_city', city);
        setCookie(ipgeolocationCookiePrefix + '_language', language);

        location.reload();
    };

    if (ipgeolocationGdpr) {
        if (getCookie(ipgeolocationGdprCookieName) == ipgeolocationGdprCookieValue) {
            if (!getCookie(ipgeolocationCookiePrefix)) {
                loadIpgeolocation(ipgeolocationUrl, setIpgeolocationCookies);
            }
        }
    } else {
        if (!getCookie(ipgeolocationCookiePrefix)) {
            loadIpgeolocation(ipgeolocationUrl, setIpgeolocationCookies);
        }
    }
})();