var loadScript = function(url, loadedCallback, encoding, scriptId) {
    encoding = encoding || 'utf-8';
    var _scriptNode = document.createElement('script');
    _scriptNode.setAttribute('type', 'text/javascript');
    if (scriptId) {
        _scriptNode.setAttribute('id', scriptId);
    }
    _scriptNode.setAttribute('charset', encoding);
    var _head = document.getElementsByTagName('head')[0];
    if (_head) {
        _head.insertBefore(_scriptNode, null);
    } else {
        var _script = document.getElementsByTagName('script')[0];
        _script.parentNode.insertBefore(_scriptNode, _script);
    }
    if (typeof (_scriptNode.addEventListener) != 'undefined') {
        _scriptNode.addEventListener('load', loadedCallback, false);
    } else {
        if (_scriptNode.readyState == 'complete') {
            loadedCallback();
        } else {
            _scriptNode.onreadystatechange = function() {
                if (_scriptNode.readyState == 'complete') {
                    _scriptNode.onreadystatechange = '';
                    loadedCallback();
                }
            }
        }
    }
    _scriptNode.setAttribute('src', url);
};

var setCookie = function(cname, cvalue, exdays, cpath) {
    var d = new Date(), path;
    d.setTime(d.getTime() + (exdays*24*60*60*1000));
    var expires = "expires="+ d.toUTCString();
    if (typeof cpath != 'undefined' && cpath != '') {
        path = "; path=" + cpath;
    } else {
        path = "; path=/";
    }
    document.cookie = cname + "=" + cvalue + "; " + expires + path;
};

var getCookie = function(cname) {
    var name = cname + "=";
    var ca = document.cookie.split(';');
    for(var i = 0; i <ca.length; i++) {
        var c = ca[i];
        while (c.charAt(0)==' ') {
            c = c.substring(1);
        }
        if (c.indexOf(name) == 0) {
            return c.substring(name.length,c.length);
        }
    }
    return "";
};

if (window.Element && !Element.prototype.closest) {
    Element.prototype.closest =
        function(s) {
            var matches = (this.document || this.ownerDocument).querySelectorAll(s),
                i,
                el = this;
            do {
                i = matches.length;
                while (--i >= 0 && matches.item(i) !== el) {};
            } while ((i < 0) && (el = el.parentElement));
            return el;
        };
}

var documentReady = function(fn) {
    if (document.attachEvent ? document.readyState === "complete" : document.readyState !== "loading") {
        fn();
    } else {
        document.addEventListener('DOMContentLoaded', fn);
    }
};

var hasClass = function(el, className) {
    return el.classList ? el.classList.contains(className) : new RegExp('\\b'+ className+'\\b').test(el.className);
};

var addClass = function(el, className) {
    if (el.classList) el.classList.add(className);
    else if (!hasClass(el, className)) el.className += ' ' + className;
};

var removeClass = function(el, className) {
    if (el.classList) el.classList.remove(className);
    else el.className = el.className.replace(new RegExp('\\b'+ className+'\\b', 'g'), '');
};
