(function () {
    var entitySwitchHostName = window.location.hostname,
        entitySwitchPathName = window.location.pathname,
        entitySwitchProtocol = window.location.protocol,
        entitySwitchSearch   = window.location.search;

    var entitySwitchCountryCodes      = ['de', 'it', 'uk', 'us', 'in', 'asia'],
        entitySwitchCookieName        = 'entitySwitch',
        entitySwitchCookieExpireDays  = 365;

    var entitySwitchCountries = [];
    entitySwitchCountries[0]  = ['DE', 'LU', 'BE'];
    entitySwitchCountries[1]  = ['IT', 'ES', 'PT'];
    entitySwitchCountries[2]  = ['GB', 'IE', 'TN', 'CY'];
    entitySwitchCountries[3]  = ['US', 'CA', 'MX', 'BZ', 'SV', 'NI', 'GT', 'HN', 'CR', 'PA'];
    entitySwitchCountries[4]  = ['IN'];
    entitySwitchCountries[5]  = ['AU', 'ID', 'CN', 'SG', 'MY', 'TH', 'HK', 'JP', 'KP', 'KR'];

    var ipdataApiKey = '0d517ab3621ff2a5c16bcf9d2c5e943d18547b7e45cf7346ca02c21b',
        ipdataUrl    = 'https://api.ipdata.co/?api-key=' + ipdataApiKey;

    if (typeof setCookie != 'function') {
        var setCookie = function(cname, cvalue, exdays, cpath) {
            var d = new Date(), path;
            d.setTime(d.getTime() + (exdays*24*60*60*1000));
            var expires = "expires="+ d.toUTCString();
            if (typeof cpath != 'undefined' && cpath != '') {
                path = ";path=" + cpath;
            } else {
                path = ";path=/";
            }
            document.cookie = cname + "=" + cvalue + ";" + expires + path;
        };
    }

    if (typeof getCookie != 'function') {
        var getCookie = function(cname) {
            var name = cname + "=";
            var decodedCookie = decodeURIComponent(document.cookie);
            var ca = decodedCookie.split(';');
            for(var i = 0; i <ca.length; i++) {
                var c = ca[i];
                while (c.charAt(0) == ' ') {
                    c = c.substring(1);
                }
                if (c.indexOf(name) == 0) {
                    return c.substring(name.length, c.length);
                }
            }
            return "";
        };
    }

    var loadIpdata = function(url, callback) {
        var ipdata = new XMLHttpRequest();
        ipdata.onreadystatechange = function() {
            if (this.readyState == 4 && this.status == 200) {
                ipdataData = JSON.parse(this.responseText);
                ipdataSuccess = true;

                if (typeof callback === 'function') {
                    callback(this.responseText);
                }
            }
        };
        ipdata.open('GET', url, true);
        ipdata.send();
    };

    var entitySwitch = function(parameter) {
        //document.getElementById('siteNavigationTrigger').checked = true;
        /*
        if (entitySwitchHostName.indexOf('staging.') !== -1 && entitySwitchHostName.indexOf('.local') !== -1) {
            window.location.href = '//www.' + parameter;
        }
        */
    };

    var entitySwitchSetCookie = function(responseText) {
        var loadedCountryCode = ipdataData.country_code,
            targetCountryCode = 'ch';

        for (i = 0; i < entitySwitchCountries.length; i++) {
            if (entitySwitchCountries[i].indexOf(loadedCountryCode) !== -1) {
                targetCountryCode = entitySwitchCountryCodes[i];
            }
        }

        setCookie(entitySwitchCookieName, targetCountryCode, entitySwitchCookieExpireDays);

        location.reload();
    };

    var entitySwitchCookieValue = getCookie(entitySwitchCookieName);

    if (typeof entitySwitchCookieValue === 'undefined' || entitySwitchCookieValue === null || entitySwitchCookieValue == '') {
        loadIpdata(ipdataUrl, entitySwitchSetCookie);
    }

    var entitySwitchTargetUrl, entitySwitchTargetCountry;

    entitySwitchTargetUrl = entitySwitchProtocol + '//' + entitySwitchHostName + entitySwitchPathName + entitySwitchSearch;
    entitySwitchTargetCountry = entitySwitchCookieValue;

    documentReady(function() {
        var /*$siteNavigation = document.getElementById('siteNavigation'),
            $siteNavigationOverlay = $siteNavigation.querySelector('.overlay'),
            $siteNavigationTrigger = document.getElementById('siteNavigationTrigger'),*/
            $languageNavigationTrigger = document.getElementById('languageNavigationTrigger'),
            $languageNavigationLabel = document.getElementById('languageNavigationLabel')/*,
            $countryNavigationTrigger = document.getElementById('countryNavigationTrigger'),
            $countryNavigationLabel = document.getElementById('countryNavigationLabel')*/;

        document.body.addEventListener('click', function(e) {
            // if (!e.target.closest('#countryNavigationContainer')) {
            //     $countryNavigationTrigger.checked = false;
            // }
            if (!e.target.closest('#languageNavigationContainer')) {
                $languageNavigationTrigger.checked = false;
            }
        });

        // var $siteNavigationInactive = $siteNavigation.querySelector('a.inactive');
        // var $siteNavigationLinks = $siteNavigation.querySelectorAll('a');
        // Array.prototype.forEach.call($siteNavigationLinks, function(el, i) {
        //     el.addEventListener('click', function(e) {
        //         if (el.getAttribute('data-country')) {
        //             e.preventDefault();

        //             var country = el.getAttribute('data-country'),
        //                 text = el.textContent;

        //             $countryNavigationTrigger.checked = false;

        //             if (country == 'ru') {
        //                 addClass($siteNavigationOverlay, 'show');
        //             } else {
        //                 $countryNavigationLabel.innerHTML = '<span>' + text + '</span>';
        //                 entitySwitchTargetCountry = country;
        //                 removeClass($siteNavigationInactive, 'inactive');
        //             }
        //         } else if (el.getAttribute('data-language')) {
        //             e.preventDefault();

        //             var language = el.getAttribute('data-language'),
        //                 url = el.getAttribute('href'),
        //                 text = el.textContent;

        //             $languageNavigationTrigger.checked = false;
        //             $languageNavigationLabel.innerHTML = '<span>' + text + '</span>';
        //             entitySwitchTargetUrl = url;
        //             removeClass($siteNavigationInactive, 'inactive');
        //         } else if (hasClass(el, 'back')) {
        //             e.preventDefault();
        //             removeClass($siteNavigationOverlay, 'show');
        //         } else if (hasClass(el, 'close')) {
        //             e.preventDefault();
        //             $siteNavigationTrigger.checked = false;
        //         } else if (hasClass(el, 'goto')) {
        //             removeClass($siteNavigationOverlay, 'show');
        //             $siteNavigationTrigger.checked = false;
        //         } else if (hasClass(el, 'switch')) {
        //             e.preventDefault();
        //             if (!hasClass(el, 'inactive')) {
        //                 setCookie(entitySwitchCookieName, entitySwitchTargetCountry, entitySwitchCookieExpireDays);
        //                 window.location.href = entitySwitchTargetUrl;
        //             }
        //         }
        //     });
        // });
    });

    /*if (!getCookie(entitySwitchCookieName)) {

        setCookie(entitySwitchCookieName, 'hide', entitySwitchCookieExpireDays);

        for (i = 0; i < entitySwitchDomains.length; i++) {
            for (ii = 0; ii < entitySwitchCountries.length; ii++) {
                if (entitySwitchCountries[ii].indexOf(entitySwitchCountryCookieValue) !== -1) {
                    var domain = entitySwitchDomains[i] + '.' + entitySwitchTlds[ii];

                    if (entitySwitchHostName.indexOf(domain) === -1) {
                        entitySwitch(domain);
                    }
                }
            }
        }
    }*/
})();