const plugin = require('tailwindcss/plugin');

module.exports = {
  important: true,
  corePlugins: {
    textOpacity: false,
    backgroundOpacity: false,
    borderOpacity: false,
  },
  content: [
    './**/*.html',
    './../../Mask/Templates/Content/TeaserSectionWithImage.html',
    './../../Mask/Templates/Content/Productbox1.html',
    './../../Mask/Templates/Content/Html5video.html',
    './../../Mask/Templates/Content/KvmAnimation.html',
    './../../Mask/Templates/Content/Picture.html',
  ],
  safelist: [
    'mb-6', 'bg-dark-blue', 'font-bold', 'bg-white', 'w-8/12', 'pl-4/12', 'pl-0', 'before:w-3_5/12', 'before:content-[\'\']',
    'text-4xl', 'md:text-6xl', 'font-jaapokki-regular', 'lg:w-10/12',
  ],
  theme: {
    screens: {
      sm: '576px',
      md: '768px',
      lg: '992px',
      xl: '1200px',
    },
    extend: {
      rotate: {
        '33': '33deg',
      },
      spacing: {
        '2px': '2px',
        '16/9': '56.25%',
        '21/7': 'calc(100% * 7 / 21)',
        '21/5': '23.81%',
        '40/68': 'calc(100% * 68 / 40)',
        '300/208': 'calc(100% * 208 / 300)',
        '3/1': '33.33333%',
        '40px': '40px',
        '100px': '100px',
        '1/2': '50%',
        '1/3': '33.333333%',
        '2/3': '66.666667%',
        '1/4': '25%',
        '2/4': '50%',
        '3/4': '75%',
        '1/5': '20%',
        '2/5': '40%',
        '3/5': '60%',
        '4/5': '80%',
        '1/6': '16.666667%',
        '2/6': '33.333333%',
        '3/6': '50%',
        '4/6': '66.666667%',
        '5/6': '83.333333%',
        '1/2/12': '4.166665%',
        '1/12': '8.333333%',
        '2/12': '16.666667%',
        '3/12': '25%',
        '3_5/12': '28.57%',
        '4/12': '33.333333%',
        '5/12': '41.666667%',
        '6/12': '50%',
        '7/12': '58.333333%',
        '8/12': '66.666667%',
        '9/12': '75%',
        '10/12': '83.333333%',
        '11/12': '91.666667%',
        'keyboardWidth': '24rem',
        'keyboardHeight': '8.25rem',
      },
      backgroundPosition: {
        'left-center': 'left center',
      },
      transformOrigin: {
        'bottom-center': 'bottom center',
      },
      fontSize: {
        base: ['1.6rem', { lineHeight: '1.625' }],
        '6xl': ['3.75rem', { lineHeight: '1.25' }],
      },
      colors: {
        'dark-blue': '#081F2C',
        'light-gray': '#F3F3F3',
        'weytec-yellow': '#dbe200'
      },
      fontFamily: {
        'jaapokki-regular': ['Jaapokki-Regular', '-apple-system', 'BlinkMacSystemFont', 'Segoe UI', 'Roboto', 'Helvetica Neue', 'Arial', 'sans-serif'],
      },
      lineHeight: {
        'relaxed-1': 1.9,
      },
      animation: {
        keyboard: "keyboard 1s",
        keyboard1: "keyboard1 1s",
        mouse: "mouse 2s",
      },
      keyframes: {
        keyboard: {
          "0%": {
            transform: "translate3d(0px, 0px, 0px) scale3d(1, 1, 1)",
            opacity: 1
          },
          "25%": {
            transform: "translate3d(0px, 0px, 0px) scale3d(1.1, 1.1, 1)",
            opacity: 1
          },
          "75%": {
            opacity: 0
          },
          "100%": {
            transform: "translate3d(0px, 0px, 0px) scale3d(0, 0, 1)",
            opacity: 0
          },
        },
        keyboard1: {
          "0%": {
            transform: "translate3d(0px, 0px, 0px) scale3d(2, 2, 1)",
            opacity: 0
          },
          "100%": {
            transform: "translate3d(0px, 0px, 0px) scale3d(1, 1, 1)",
            opacity: 1
          },
        },
        mouse: {
          "100%": {
            transform: "rotate(0deg)",
            'margin-top': "-10%",
          },
        },
      },
    },
  },
  plugins: [
    plugin(({ addUtilities }) => {
      const animationDelayUtilities = {};

      for (var i = 1; i < 100000; i++ ) {
        animationDelayUtilities['.animation-delay-' + i] = {
          'animation-delay': i + 'ms !important',
        }
      };

      addUtilities(animationDelayUtilities);
    }),
  ],
}
