# WEYTEC Website & myWEYTEC

## Inhalt
- [Ansprechpartner](#ansprechpartner)
- [Hosting](#hosting)
- [Domains](#domains)
- [Staging](#staging)
- [Sprachen/Länderversionen](#sprachenländerversionen)
- [myWEYTEC](#myweytec)
  - [Benutzer](#benutzer)
  - [Dateispeicher](#dateispeicher)
- [Landingpage Intranet](#landingpage-intranet)
- [Formulare](#formulare)
- [Inhaltselemente](#inhaltselemente)
  - [Animation Why WEYTEC](#animation-why-weytec)
  - [Animation SMART](#animation-smart)
  - [EOL Liste](#eol-liste)
  - [Messekalender](#messekalender)

## Ansprechpartner

Hauptansprechpartner in dem Projekt sind intern Gregor Funk und Sharmon Greenky (<sharmon.greenky@weytec.com>) auf Seiten der WEY Technology AG.

## Hosting

Die Website liegt in einem Hostingpaket auf unserem Server von AIXPRO/dogado.

Der Webroot der Website ist
```bash
/var/www/vhosts/weytec.com/httpdocs/www.weytec.com
```

Der Webroot von myWEYTEC ist
```bash
/var/www/vhosts/weytec.com/httpdocs/my.weytec.com
```

## Domains

Die Domains werden grundsätzlich von der WEY Technology AG verwaltet. Für die Webseiten sind Nameservereinträge (A-Record) auf unseren Server gesetzt.

Die Hauptdomain der Website ist <https://www.weytec.com/>

Weitere Domains sind  
<https://www.weytec.asia/>  
<https://www.weytec.ch/>  
<https://www.weytec.co.uk/>  
<https://www.weytec.de/>  
<https://www.weytec.fr/>  
<https://www.weytec.it/>  
<https://www.weytec.ru/>  
<https://www.weytec.us/>

Diese Domains werden über das Kundenmenü von AIXPRO/dogado auf die entsprechende Sprache der Website weitergeleitet.

Die Domain <https://www.weytec.ru/> wird mittlerweile von der Tochterfirma WEY Technology LLC für einen eigenen Webauftritt verwendet.

Die Hauptdomain von myWEYTEC ist <https://my.weytec.com/>

## Staging

Die Stagingumgebung der Website dient als Testsystem und Bearbeitungsgrundlage für das Livesystem. Dabei wird die Extension Content Publisher (in2publish_core) genutzt um Inhalte und Dateien aus dem Staging- in das Produktivsystem zu pushen.

Der Webroot der Stagingumgebung ist
```bash
/var/www/vhosts/weytec.com/httpdocs/staging.weytec.com
```

Die Staging-Domain ist <https://staging.weytec.com/>

## Sprachen/Länderversionen

Es gibt aktuell zwei Sprachen der Website – Deutsch und Englisch.

Die "Länderversionen" werden über partiell unterschiedliche Inhalte abgebildet. Die Umschaltung zwischen den Länderversionen erfolgt mittels JavaScript (Resources/Public/JavaScript/entityswitch.js) über den Dialog für den Sprachwechsel. Hierbei wird die Auswahl in einem Cookie gespeichert. Falls dieser Cookie noch nicht existiert, wird über eine IP Geolocation ([ipdata.co](https://ipdata.co/)) das Land des Besuchers abgefragt und der entsprechende Ländercode im Cookie gespeichert. Die Zuordnung des Ländecodes erfolgt ebenfalls über o.g. JavaScript.

Die unterschiedlichen Inhalte der Länderversionen können aktuell über zwei Mask-Inhaltselemente gepflegt werden – Ansprechpartner (contact) und Text (text). Über eine Abfrage in den Templates der Inhaltselemente wird über eine TypoScript Library (lib.entitycode), welche den Cookie ausliest, dann der entsprechende Inhalt angezeigt.

## myWEYTEC

myWEYTEC ist eine Website mit vorgeschaltetem Login zur Bereitstellung von Dokumenten unterschiedlichster Art für Mitarbeiter und Kunden der WEY Technology AG.

Die Website wird ausschließlich in der Sprache Englisch genutzt. Über die htaccess-Datei ist geregelt, dass auch nur diese angezeigt wird.

Ursprünglich war myWEYTEC in das CMS der Website integriert. Wurde aber dann aufgrund von Problemen bzw. Umständlichkeiten mit dem Stagingsystem ausgelagert und läuft jetzt in einer eigenen TYPO3-Instanz. Beide Systeme bedienen sich aber aus demselben Template-Repository.

### Benutzer

Die Benutzer für den Login wurden erstmalig in die Datenbank importiert. Zudem gibt es die Möglichkeit sich über ein Online-Formular zu registrieren. Die Freischaltung erfolgt durch die WEY Technology AG über das Backend des CMS.

### Dateispeicher

Für die Dateiablage wurde anfangs ein Amazon S3 Konto (ZWEI14; Zugangsdaten im 1Password) genutzt. Da es hierbei aber immer wieder zu Problemen bei der Synchronisation kam, wurde auf einen internen Dateispeicher (Webserver) umgestellt. Um die Downloads zu schützen wurde nachträglich dann noch die Extension FAL Secure Download (fal_securedownload) implementiert. Der Dateispeicher (myWEYTEC) weist jetzt auf einen Serverpfad außerhalb des Webroots.

Der Speicherort der Dateien ist
```bash
/var/www/vhosts/weytec.com/httpdocs/myweytec
```

## Landingpage Intranet

Auf Wunsch der WEY Technology AG wurde eine Landingpage für diverse Verlinkungen erstellt.

Die Domain der Landingpage ist <https://intra.weytec.com/>

Verantwortlich für den Inhalt der Landingpage ist Urs Daenzer (<urs.daenzer@weytec.com>) auf Seiten der WEY Technology AG.

## Formulare

Bei den Formularen muss zwingend immer der Absender <auto.sender@weytec.com> gesetzt werden, da es sonst zu Problemen beim Empfang seitens der WEY Technology AG kommt. Diese E-Mail-Adresse ist im Mailingsystem als vertrauenswürdig eingestuft.

Das Online-Bewerbungsformular wurde mittlerweile auf ein externes System umgestellt und wird von der WEY Technology AG verwaltet.

## Inhaltselemente

Die "speziellen" Inhaltselemente sind mit der Extension Mask umgesetzt.

Im Folgenden sind die Inhaltselemente mit Erklärungsbedarf aufgeführt.

### Animation Why WEYTEC

Bei diesem Inhaltselement werden einzelne DOM-Elemente mittels (Inline-)JavaScript ein- und ausgeblendet. Die Animation kann am Ende über einen Button wieder neu gestartet werden.

Über das CMS-Backend können die Texte vor und nach der Animation gepflegt werden.

###  Animation SMART

Dieses Inhaltselement war ursprünglich auf der Seite Why WEYTEC platziert. Mittels (Inline-)JavaScript wurde das Scrollen des Nutzers abgefragt und anhand der Scrollposition DOM-Elemente ein- und ausgeblendet.

Inzwischen wurde dieses Element auf der Seite durch ein Akkordeon-Inhaltselement ersetzt.

### EOL Liste

Die End-of-Life Liste wird im Deutschen gepflegt. Zur Übersetzung ins Englische wird zunächste das englische Inhaltselement (EOL Liste) gelöscht und dann über den Button "Übersetzen (Translate)" aus dem Deutschen ins Englische lokalisiert ("in die Sprache kopiert"). Wurde eine PDF-Datei neu hinzugefügt oder aktualisiert und verlinkt, muss die PDF-Datei im Englischen beim entsprechenden Eintrag in der EOL Liste auch noch lokalisiert werden. Dies geschieht über den Button "Alle Datensätze lokalisieren (Localize all records)" beim jeweiligen Eintrag im Inhaltselement.

Zur Veröffentlichung in das Produktivsystem müssen zunächst die neuen bzw. aktualisierten PDF-Dateien über das CMS Modul "Publisher Dateien (Publish Files)" gepusht werden. Danach können die Änderungen an der Seite über das Modul "Publisher Übersicht (Publish Overview)" in das Livesystem überführt werden.

### Messekalender

In der Vergangenheit kam es bei dem Inhaltselement Messekalender immer wieder zu Problemen bei der Veröffentlichung aus dem Staging- ins Produktivsystem. Vermutung war, dass es aufgrund verschachtelter sich wiederholender Listen innerhalb des Inhaltselements zu Konflikten mit dem Content Publisher kam. Aus diesem Grund wurde das Element neu umgesetzt (events -> fairs), so dass es nun nur noch eine sich wiederholende Liste gibt. Seit dieser Umstellung gab es keiin (negatives) Feedback mehr zur irgendwelchen Problemen beim Pushen.