<?php
namespace ZWEI14\T3template\Hooks;

/***************************************************************
 *  Copyright notice
 *
 *  (c) 2013 Eric Chavaillaz (eric.chavaillaz@gmail.com)
 *  All rights reserved
 *
 *  This script is part of the TYPO3 project. The TYPO3 project is
 *  free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  The GNU General Public License can be found at
 *  http://www.gnu.org/copyleft/gpl.html.
 *  A copy is found in the textfile GPL.txt and important notices to the license
 *  from the author is found in LICENSE.txt distributed with these scripts.
 *
 *  This script is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  This copyright notice MUST APPEAR in all copies of the script!
 ***************************************************************/

/**
 * Class PageLayoutControllerHook.
 *
 * @author Eric Chavaillaz <eric.chavaillaz@gmail.com>
 */
class PageLayoutControllerHook {
	/**
	 * My example function
	 *
	 * @param array $parameters
	 * @param \TYPO3\CMS\Backend\Controller\PageLayoutController $parentObject
	 * @return string
	*/
	public function example(array $parameters, \TYPO3\CMS\Backend\Controller\PageLayoutController $parentObject) {
		$output = '';

		if (!isset($parentObject->pageinfo->description)) {
//			$output .= '<h3>SEO informations</h3>'
//				. '<div class="typo3-message message-warning">'
//				. '<div class="message-body">'
//				. 'There is no description for this page.'
//				. ' </div>'
//				. '</div>';
            $output .= '<div class="typo3-messages">'
                . '<div class="alert alert-warning">'
                . '<div class="media">'
                . '<div class="media-left">'
                . '<span class="fa-stack fa-lg">'
                . '<i class="fa fa-circle fa-stack-2x"></i>'
                . '<i class="fa fa-exclamation fa-stack-1x"></i>'
                . '</span>'
                . '</div>'
                . '<div class="media-body">'
                . '<h4 class="alert-title">SEO informations</h4>'
                . '<p class="alert-message">There is no description for this page.</p>'
                . '</div>'
                . '</div>'
                . '</div>'
                . '</div>';
            $output .= '<div class="callout callout-warning">'
                . '<div class="media">'
                . '<div class="media-left">'
                . '<span class="fa-stack fa-lg callout-icon">'
                . '<i class="fa fa-circle fa-stack-2x"></i>'
                . '<i class="fa fa-exclamation fa-stack-1x"></i>'
                . '</span>'
                . '</div>'
                . '<div class="media-body">'
                . '<h4 class="callout-title">Warning</h4>'
                . '<div class="callout-body">Lorem ipsum dolor sit amet.</div>'
                . '</div>'
                . '</div>'
                . '</div>';
		}

		return $output;
	}
}
