/**
 * Using API https://ipdata.io/
 * Free 1500 requests per day
 *
 * Use the API key 'test' for testing purposes
 *
 */

(function () {
    var ipdataApiKey           = '0d517ab3621ff2a5c16bcf9d2c5e943d18547b7e45cf7346ca02c21b',
        ipdataUrl              = 'https://api.ipdata.co/?api-key=' + ipdataApiKey,
        ipdataCookiePrefix     = 'ipdata',
        ipdataCookieExpireDays = 1,
        ipdataSuccess          = false,
        ipdataData             = {},
        ipdataGdpr             = true,
        ipdataGdprCookieName   = 't3cookieconsent',
        ipdataGdprCookieValue  = 'allow';

    if (typeof setCookie != 'function') {
        var setCookie = function(cname, cvalue, exdays, cpath) {
            var d = new Date(), path;
            d.setTime(d.getTime() + (exdays*24*60*60*1000));
            var expires = "expires="+ d.toUTCString();
            if (typeof cpath != 'undefined' && cpath != '') {
                path = ";path=" + cpath;
            } else {
                path = ";path=/";
            }
            document.cookie = cname + "=" + cvalue + ";" + expires + path;
        };
    }

    if (typeof getCookie != 'function') {
        var getCookie = function(cname) {
            var name = cname + "=";
            var decodedCookie = decodeURIComponent(document.cookie);
            var ca = decodedCookie.split(';');
            for(var i = 0; i <ca.length; i++) {
                var c = ca[i];
                while (c.charAt(0) == ' ') {
                    c = c.substring(1);
                }
                if (c.indexOf(name) == 0) {
                    return c.substring(name.length, c.length);
                }
            }
            return "";
        };
    }

    var loadIpdata = function(url, callback) {
            var ipdata = new XMLHttpRequest();
            ipdata.onreadystatechange = function() {
                if (this.readyState == 4 && this.status == 200) {
                    ipdataData = JSON.parse(this.responseText);
                    ipdataSuccess = true;

                    if (typeof callback === 'function') {
                        callback(this.responseText);
                    }
                }
            };
            ipdata.open('GET', url, true);
            ipdata.send();
    };

    var setIpdataCookies = function(responseText) {
        var continentCode  = ipdataData.continent_code,
            continentName  = ipdataData.continent_name,
            countryCode    = ipdataData.country_code,
            countryName    = ipdataData.country_name,
            regionCode     = ipdataData.region_code,
            regionName     = ipdataData.region,
            city           = ipdataData.city,
            latitude       = ipdataData.latitude,
            longitude      = ipdataData.longitude,
            languageName   = ipdataData.languages[0].name,
            languageNative = ipdataData.languages[0].native;

        var language = window.navigator.languages && window.navigator.languages[0] || // Chrome / Firefox
            window.navigator.language ||   // All browsers
            window.navigator.userLanguage; // IE <= 10

        setCookie(ipdataCookiePrefix, 'load', ipdataCookieExpireDays);
        setCookie(ipdataCookiePrefix + '_continent_code', continentCode);
        setCookie(ipdataCookiePrefix + '_continent_name', continentName);
        setCookie(ipdataCookiePrefix + '_country_code', countryCode);
        setCookie(ipdataCookiePrefix + '_country_name', countryName);
        setCookie(ipdataCookiePrefix + '_region_code', regionCode);
        setCookie(ipdataCookiePrefix + '_region_name', regionName);
        setCookie(ipdataCookiePrefix + '_city', city);
        setCookie(ipdataCookiePrefix + '_latitude', latitude);
        setCookie(ipdataCookiePrefix + '_longitude', longitude);
        setCookie(ipdataCookiePrefix + '_language', language);
        setCookie(ipdataCookiePrefix + '_language_name', languageName);
        setCookie(ipdataCookiePrefix + '_language_native', languageNative);

        location.reload();
    };

    if (ipdataGdpr) {
        if (getCookie(ipdataGdprCookieName) == ipdataGdprCookieValue) {
            if (!getCookie(ipdataCookiePrefix)) {
                loadIpdata(ipdataUrl, setIpdataCookies);
            }
        }
    } else {
        if (!getCookie(ipdataCookiePrefix)) {
            loadIpdata(ipdataUrl, setIpdataCookies);
        }
    }
})();