// http://codepen.io/jensgro/pen/aIxEu
var isTouchDevice = 'ontouchstart' in document.documentElement || window.Touch || 'createTouch' in document;

// https://www.sitepoint.com/jquery-check-window-iframe/
// https://tommcfarlin.com/check-if-a-page-is-in-an-iframe/
//var isInIframe = (window.self !== window.top) ? true : false;
var isInIframe = (window.location != window.parent.location) ? true : false;

var cssPointerEvents = function() {
    var element = document.createElement('x'),
        documentElement = document.documentElement,
        getComputedStyle = window.getComputedStyle,
        supports;
    if(!('pointerEvents' in element.style)){
        return false;
    }
    element.style.pointerEvents = 'auto';
    element.style.pointerEvents = 'x';
    documentElement.appendChild(element);
    supports = getComputedStyle &&
        getComputedStyle(element, '').pointerEvents === 'auto';
    documentElement.removeChild(element);
    return !!supports;
};

var checkAspectRatio = function(container, width, height) {
    $(container).each(function(i, el) {
        var $el = $(el),
            h = $el.outerHeight(),
            w = $el.outerWidth(),
            ratio = w / h,
            aspectRatio = width / height;
        if (ratio >= aspectRatio) {
            $el.removeClass('vertical');
            $el.addClass('horizontal');
        } else {
            $el.removeClass('horizontal');
            $el.addClass('vertical');
        }
    });
};

var scrollToElement = function(container, speed, offset) {
    $el = container;
    $("html, body").stop().animate({ scrollTop: $el.offset().top - offset }, speed);
};

$.fn.extend({
    addClassDelayed: function(c, d) {
        var $el = $(this);
        setTimeout(function() { $el.addClass(c); }, d);
    },
    removeClassDelayed: function(c, d) {
        var $el = $(this);
        setTimeout(function() { $el.removeClass(c); }, d);
    },
    fadeInDelayed: function(d, s) {
        var $el = $(this);
        s = typeof s !== 'undefined' ? s : '300';
        setTimeout(function() { $el.fadeIn(s); }, d);
    },
    fadeOutDelayed: function(d, s) {
        var $el = $(this);
        s = typeof s !== 'undefined' ? s : '300';
        setTimeout(function() { $el.fadeOut(s); }, d);
    },
    moveDelayed: function(x, y, d) {
        var $el = $(this);
        d = typeof d !== 'undefined' ? d : '0';
        setTimeout(function() {
            $el.css({
                '-webkit-transform': 'translate(' + x + ', ' + y + ')',
                '-ms-transform':     'translate(' + x + ', ' + y + ')',
                'transform':         'translate(' + x + ', ' + y + ')'
            });
        }, d);
    },
    isInViewport: function() {
        var $el = $(this),
            elemTop = $el.offset().top,
            elemBottom = elemTop + $el.outerHeight(),
            $win = $(window),
            winTop = $win.scrollTop(),
            winBottom = winTop + $win.height();
        if (elemBottom < winTop) {
            return false;
        } else if (elemTop > winBottom) {
            return false;
        } else {
            return true;
        }
    },
    isOnScreen: function() {
        var $el = $(this),
            elemTop = $el.offset().top,
            $win = $(window),
            winTop = $win.scrollTop(),
            winBottom = winTop + $win.height();
        if (elemTop >= winBottom) {
            return false;
        } else {
            return true;
        }
    },
    getRows: function() {
        var $el = $(this),
            elemHeight = $el.height(),
            lineHeight = $el.css('line-height'),
            rows = Math.round(elemHeight / parseInt(lineHeight));
        return rows;
    }
});

var $window,
    $document,
    $html,
    $body,
    viewportWidth,
    viewportHeight,
    documentWidth,
    documentHeight,
    scrollPositionY,
    vw,
    vh,
    $fullScreen;

$(function() {
    $window = $(window);
    $document = $(document);
    $html = $("html");
    $body = $("body");
    viewportWidth = $window.width();
    viewportHeight = window.innerHeight ? window.innerHeight : $window.height();
    documentWidth = $document.width();
    documentHeight = $document.height();
    scrollPositionY = $window.scrollTop();
    vw = viewportWidth / 100;
    vh = viewportHeight / 100;
    $fullScreen = $(".fullScreen");

    // is.js
    if (typeof is != 'undefined') {
        if (is.ie(5)) {
            $html.addClass('lt-ie9 lt-ie8 lt-ie7 lt-ie6');
        }

        if (is.ie(6)) {
            $html.addClass('lt-ie9 lt-ie8 lt-ie7');
        }

        if (is.ie(7)) {
            $html.addClass('lt-ie9 lt-ie8');
        }

        if (is.ie(8)) {
            $html.addClass('lt-ie9');
        }

        if (is.ie()) {
            $html.addClass('ie');
        }
    }

    // feature.js
    if (typeof feature != 'undefined') {
        if (feature.touch) {
            $html.addClass('touch');
        }

        if (feature.geolocation) {
            $html.addClass('geolocation');
        }

        if (feature.viewportUnit) {
            $html.addClass('viewportUnit');
        }

        if (feature.cssTransform) {
            $html.addClass('cssTransform');
        }

        if (feature.css3Dtransform) {
            $html.addClass('css3Dtransform');
        }

        if (feature.touch || !feature.viewportUnit) {
            //$("body.home #bannerSliderArea, body.portal #mainColArea").height(viewportHeight);
        }
    }

    /*if (isTouchDevice == true) {
        $html.addClass('touch');
    }*/

    /*if (cssPointerEvents) {
        $html.addClass('cssPointerEvents');
    }*/

    if (isInIframe) {
        $html.addClass('isInIframe');
    }

    $(".backStretch").each(function(i, el) {
        var $el = $(el),
            s = $el.attr('data-src'),
            p = $el.attr('data-pos');
        if (typeof s != 'undefined' && s != '')
            $el.css('background-image', 'url(' + s + ')');
        if (typeof p != 'undefined' && p != '')
            $el.css('background-position', p)
    });

    $window.resize(function() {
        viewportWidth = $window.width();
        viewportHeight = window.innerHeight ? window.innerHeight : $window.height();
        documentWidth = $document.width();
        documentHeight = $document.height();
        scrollPositionY = $window.scrollTop();
        vw = viewportWidth / 100;
        vh = viewportHeight / 100;

        $fullScreen.css({
            'width': viewportWidth,
            'height': viewportHeight
        });

        checkAspectRatio(".checkAspectRatio4x3", 4, 3);
        checkAspectRatio(".checkAspectRatio16x9", 16, 9);
        checkAspectRatio(".checkAspectRatio21x9", 21, 9);

        $(".matchHeight").matchHeight();
    }).resize();

    $window.scroll(function() {
        viewportWidth = $window.width();
        viewportHeight = window.innerHeight ? window.innerHeight : $window.height();
        documentWidth = $document.width();
        documentHeight = $document.height();
        scrollPositionY = $window.scrollTop();
        vw = viewportWidth / 100;
        vh = viewportHeight / 100;
    });

    $window.load(function() {
        viewportWidth = $window.width();
        viewportHeight = window.innerHeight ? window.innerHeight : $window.height();
        documentWidth = $document.width();
        documentHeight = $document.height();
        scrollPositionY = $window.scrollTop();
        vw = viewportWidth / 100;
        vh = viewportHeight / 100;

        checkAspectRatio(".checkAspectRatio4x3", 4, 3);
        checkAspectRatio(".checkAspectRatio16x9", 16, 9);
        checkAspectRatio(".checkAspectRatio21x9", 21, 9);

        $(".matchHeight").matchHeight();
    });
});