$(function() {
    var fullpageSelector = '.cec-mask_header';

    var scrollUp = function() {
        var vheight = window.innerHeight ? window.innerHeight : $(window).height();

        $('html, body').stop().animate({
            scrollTop: (Math.ceil($(window).scrollTop() / vheight)-1) * vheight
        }, 500);
    };

    var scrollDown = function() {
        var vheight = window.innerHeight ? window.innerHeight : $(window).height();

        $('html, body').stop().animate({
            scrollTop: (Math.floor($(window).scrollTop() / vheight)+1) * vheight
        }, 500);
    };

    //$("body").addClass('overflowHidden').append('<div id="pageNavigationContainer"><nav id="pageNavigation" role="navigation"><ul></ul></nav></div>');
    $("body").addClass('overflowHidden');

    /*
    $(fullpageSelector).each(function(i, el) {
        var $el = $(el);

        $("#pageNavigation ul").append('<li><a href="#' + $el.attr('id') + '"><span>' + (i + 1) + '</span></a></li>');
    });
    */

    //var lastId, menuItems, scrollItems;

    /*
    menuItems = $("#pageNavigation").find('a');
    scrollItems = menuItems.map(function(){
        var item = $($(this).attr("href"));
        if (item.length) { return item; }
    });

    menuItems.click(function(e){
        var href = $(this).attr("href"),
            offsetTop = href === "#" ? 0 : $(href).offset().top+1;

        $('html, body').stop().animate({
            scrollTop: offsetTop
        }, 500);

        e.preventDefault();
    });
    */

    $(window).resize(function() {
        /*
        var fromTop = $(this).scrollTop() + 1;

        var cur = scrollItems.map(function(){
            if ($(this).offset().top < fromTop)
                return this;
        });

        cur = cur[cur.length-1];
        var id = cur && cur.length ? cur[0].id : "";

        if (lastId !== id) {
            if ($("#" + id).hasClass('linearGradient')) {
                $('#pageNavigation').addClass('inverted');
            } else {
                $('#pageNavigation').removeClass('inverted');
            }

            lastId = id;

            menuItems
                .parent().removeClass("active")
                .end().filter("[href='#"+id+"']").parent().addClass("active");
        }
        */
    }).resize();

    $(window).scroll(function() {
        /*
        var fromTop = $(this).scrollTop() + 1;

        var cur = scrollItems.map(function(){
            if ($(this).offset().top < fromTop)
                return this;
        });

        cur = cur[cur.length-1];
        var id = cur && cur.length ? cur[0].id : "";

        if (lastId !== id) {
            if ($("#" + id).hasClass('linearGradient')) {
                $('#pageNavigation').addClass('inverted');
            } else {
                $('#pageNavigation').removeClass('inverted');
            }

            lastId = id;

            menuItems
                .parent().removeClass("active")
                .end().filter("[href='#"+id+"']").parent().addClass("active");
        }
        */
    });

    var mw1 = 0,
        mw2 = 0,
        lock;

    var jsUrl = 'https://cdnjs.cloudflare.com/ajax/libs/jquery-mousewheel/3.1.13/jquery.mousewheel.min.js';

    loadScript(jsUrl, function() {
        $(".fullScreenServicesMouse").fadeInDelayed(4000, 500);

        $(fullpageSelector).mousewheel(function(e, delta) {
            var scrollPositionY = $window.scrollTop();

            if(((delta > 0 && delta < mw2 && mw2 > mw1) || (delta < 0 && delta > mw2 && mw2 < mw1)) && !lock) {
                if (delta < 0) {
                    scrollDown();
                } else if (delta > 0) {
                    if (scrollPositionY > 0) {
                        scrollUp();
                    }
                }

                lock = true;
                window.setTimeout(function() { lock = false; }, 600);
            }
            mw1 = mw2;
            mw2 = delta;

            //e.preventDefault();
        });
    });

    $(document).keydown(function(e) {
        var scrollPositionY = $window.scrollTop();

        if (!lock) {
            if (e.keyCode == 40) {
                scrollDown();
            } else if (e.keyCode == 34) {
                scrollDown();
            } else if (e.keyCode == 33) {
                if (scrollPositionY > 0) {
                    scrollUp();
                }
            } else if (e.keyCode == 38) {
                if (scrollPositionY > 0) {
                    scrollUp();
                }
            }

            lock = true;
            window.setTimeout(function(){
                lock = false;
            }, 600);
        }
    });

    var supportTouch = feature.touch,
        scrollEvent = "touchmove scroll",
        touchStartEvent = supportTouch ? "touchstart" : "mousedown",
        touchStopEvent = supportTouch ? "touchend" : "mouseup",
        touchMoveEvent = supportTouch ? "touchmove" : "mousemove";

    $.event.special.swipeupdown = {
        setup: function() {
            var thisObject = this;
            var $this = $(thisObject);
            $this.bind(touchStartEvent, function(event) {
                var data = event.originalEvent.touches ?
                        event.originalEvent.touches[ 0 ] :
                        event,
                    start = {
                        time: (new Date).getTime(),
                        coords: [ data.pageX, data.pageY ],
                        origin: $(event.target)
                    },
                    stop;

                function moveHandler(event) {
                    if (!start) {
                        return;
                    }
                    var data = event.originalEvent.touches ?
                        event.originalEvent.touches[ 0 ] :
                        event;
                    stop = {
                        time: (new Date).getTime(),
                        coords: [ data.pageX, data.pageY ]
                    };

                    // prevent scrolling
                    if (Math.abs(start.coords[1] - stop.coords[1]) > 10) {
                        event.preventDefault();
                    }
                }
                $this
                    .bind(touchMoveEvent, moveHandler)
                    .one(touchStopEvent, function(event) {
                        $this.unbind(touchMoveEvent, moveHandler);
                        if (start && stop) {
                            if (stop.time - start.time < 1000 &&
                                Math.abs(start.coords[1] - stop.coords[1]) > 30 &&
                                Math.abs(start.coords[0] - stop.coords[0]) < 75) {
                                start.origin
                                    .trigger("swipeupdown")
                                    .trigger(start.coords[1] > stop.coords[1] ? "swipeup" : "swipedown");
                            }
                        }
                        start = stop = undefined;
                    });
            });
        }
    };

    $.each({
        swipedown: "swipeupdown",
        swipeup: "swipeupdown"
    }, function(event, sourceEvent){
        $.event.special[event] = {
            setup: function(){
                $(this).bind(sourceEvent, $.noop);
            }
        };
    });

    $('body').on('swipedown',function() {
        var scrollPositionY = $window.scrollTop();
        if (scrollPositionY > 0) {
            scrollUp();
        }
    } );

    $('body').on('swipeup',function() {
        scrollDown();
    } );

    $document.on('click', '.headerSkip', function(e) {
        e.preventDefault();

        scrollDown();
    });

    $window.load(function() {
    });
});