/**
 * Check a cookie with a country code and compare it to predefined country domain mappings
 * If there is another domain for the current country code URL combination, a browser switch function is executed
 *
 * @param {array} browserSwitchDomains The domain names for browser switching
 * @param {array} browserSwitchTlds The top level domains for browser switching
 * @param {array} browserSwitchCountries The assignment of country codes to the top level domains
 * @param {string} browserSwitchCountryCookieName The name of the cookie with the country code
 *
 * @function browserSwitch Here comes the code for your browser switching action
 *
 */
(function () {
    var browserSwitchDomains           = ['weytec'],
        browserSwitchTlds              = ['de', 'ch', 'fr', 'it', 'ru', 'us', 'co.uk', 'asia'],
        browserSwitchHostName          = window.location.hostname,
        browserSwitchCookieName        = 'browserswitch',
        browserSwitchCookieExpireDays  = 1,
        browserSwitchCountryCookieName = 'ipdata_country_code';

    var browserSwitchCountries = [];
    browserSwitchCountries[0]  = ['DE'];
    browserSwitchCountries[1]  = ['CH'];
    browserSwitchCountries[2]  = ['FR', 'LU', 'BE'];
    browserSwitchCountries[3]  = ['IT', 'ES', 'PT'];
    browserSwitchCountries[4]  = ['RU', 'UA', 'BY'];
    browserSwitchCountries[5]  = ['US', 'CA', 'BZ', 'CR', 'SV', 'GT', 'HN', 'NI', 'PA'];
    browserSwitchCountries[6]  = ['GB', 'IE', 'NL', 'NO', 'SE', 'FI', 'DK', 'IS', 'CY', 'DZ', 'EG', 'LY', 'MA', 'SS', 'SD', 'TN', 'EH'];
    browserSwitchCountries[7]  = ['AU', 'ID', 'IN', 'CN', 'SG', 'MY', 'TH', 'HK', 'JP', 'KP', 'KR'];

    if (typeof setCookie != 'function') {
        var setCookie = function(cname, cvalue, exdays, cpath) {
            var d = new Date(), path;
            d.setTime(d.getTime() + (exdays*24*60*60*1000));
            var expires = "expires="+ d.toUTCString();
            if (typeof cpath != 'undefined' && cpath != '') {
                path = ";path=" + cpath;
            } else {
                path = ";path=/";
            }
            document.cookie = cname + "=" + cvalue + ";" + expires + path;
        };
    }

    if (typeof getCookie != 'function') {
        var getCookie = function(cname) {
            var name = cname + "=";
            var decodedCookie = decodeURIComponent(document.cookie);
            var ca = decodedCookie.split(';');
            for(var i = 0; i <ca.length; i++) {
                var c = ca[i];
                while (c.charAt(0) == ' ') {
                    c = c.substring(1);
                }
                if (c.indexOf(name) == 0) {
                    return c.substring(name.length, c.length);
                }
            }
            return "";
        };
    }

    var browserSwitch = function(parameter) {
        //document.getElementById('siteNavigationTrigger').checked = true;
        /*
        if (browserSwitchHostName.indexOf('staging.') !== -1 && browserSwitchHostName.indexOf('.local') !== -1) {
            window.location.href = '//www.' + parameter;
        }
        */
    };

    var browserSwitchCountryCookieValue = getCookie(browserSwitchCountryCookieName);

    document.addEventListener("DOMContentLoaded", function() {
        if (getCookie(browserSwitchCountryCookieName) != '') {
            if (!getCookie(browserSwitchCookieName)) {
                setCookie(browserSwitchCookieName, 'hide', browserSwitchCookieExpireDays);

                for (i = 0; i < browserSwitchDomains.length; i++) {
                    for (ii = 0; ii < browserSwitchCountries.length; ii++) {
                        if (browserSwitchCountries[ii].indexOf(browserSwitchCountryCookieValue) !== -1) {
                            var domain = browserSwitchDomains[i] + '.' + browserSwitchTlds[ii];

                            if (browserSwitchHostName.indexOf(domain) === -1) {
                                browserSwitch(domain);
                            }
                        }
                    }
                }
            }
        }
    });
})();