<?php
namespace ZWEI14\T3template\Utility;

use TYPO3\CMS\Core\Utility\GeneralUtility;
use /** @noinspection PhpUnusedAliasInspection */
    TYPO3\CMS\Extbase\Utility\DebuggerUtility;
use TYPO3\CMS\Frontend\Page\PageRepository;

/**
 * Class InheritanceUtility
 *
 * @package ZWEI14\T3template\Utility
 */
class InheritanceUtility
{

    /**
     * @return \TYPO3\CMS\Core\Database\DatabaseConnection
     */
    protected function getDatabaseConnection() {
        return $GLOBALS['TYPO3_DB'];
    }

    /**
     * @var \TYPO3\CMS\Core\Database\PreparedStatement
     */
    protected $preparedStatement;

    protected function getPreparedStatement()
    {
        if (is_null($this->preparedStatement)) {
            $this->preparedStatement = $this->getDatabaseConnection()->prepare_SELECTquery(
                'uid, inherit_from',
                'pages',
                'pid = :pid'
            );
        }
        return $this->preparedStatement;
    }

    /**
     * InheritanceUtility destructor.
     */
    public function __destruct()
    {
        if (!empty($this->preparedStatement)) {
            $this->preparedStatement->free();
        }
    }

    /**
     * Seite
     *
     * @param string $content
     * @param array $conf
     * @return integer
     */
    public function templatePageLinkToLocalLink($content, $conf) {
        if(!intval($content)) { // Keine Seite angegeben (externerLink/Email etc.)
            return $content;
        }
        $sysPageObj = GeneralUtility::makeInstance(PageRepository::class);
        $rootLine = $sysPageObj->getRootLine(intval($content));
        $substitute = false;
        foreach ($rootLine as $page) {
            //$substitute = $substitute || ($page['uid'] == $conf['templatePage']);
            $substitute = $substitute || ($page['uid'] == 42);
        }
        if(!$substitute) { // Seite befindet sich nicht unter dem Vererbungs-Root
            return $content;
        }
        //$res = $this->getChildPageInheritingFrom($conf['localRoot'], intval($content));
        $res = $this->getChildPageInheritingFrom(1, intval($content));
        return $res;
    }

    /**
     * Recursion
     *
     * @param integer $uid
     * @param integer $inherit
     * @return integer|null
     */
    protected function getChildPageInheritingFrom($uid, $inherit) {
        if($this->getPreparedStatement()->execute([':pid' => intval($uid)])) {
            $children = $this->getPreparedStatement()->fetchAll();
            foreach($children as $child) {
                if(intval($child['inherit_from']) == intval($inherit)) {
                    return $child['uid'];
                }
            }
            foreach($children as $child) {
                $res = $this->getChildPageInheritingFrom($child['uid'], $inherit);
                if($res) {
                    return $res;
                }
            }
        }
        return null;
    }

}