<?php

declare(strict_types = 1);

/*
 * This file is a custom finisher for the client BGFH
 * ZWI14 GmbH - 2021
 *
 */


namespace ZWEI14\T3template\Domain\Finishers;

// use...
use TYPO3\CMS\Form\Domain\Finishers\AbstractFinisher;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use Symfony\Component\Serializer\Serializer;
use Symfony\Component\Serializer\Encoder\CsvEncoder;
use Symfony\Component\Serializer\Normalizer\ObjectNormalizer;
use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\Filesystem\Exception\IOExceptionInterface;
use Symfony\Component\Finder\Finder;
use DateTime;

/**
 * This finisher ...
 * Use this e.g after the email finisher if you ...
 *
 * Scope: frontend
 */
class DataToCsvFinisher extends AbstractFinisher
{

    /**
     * Executes this finisher
     * @see AbstractFinisher::execute()
     */
    protected function executeInternal()
    {
        $sAbsolutePathToFileadmin = rtrim($_SERVER['DOCUMENT_ROOT'], '/'); //rtrim(GeneralUtility::getFileAbsFileName('fileadmin'), "/");
        $sRelativePathToCsv = '/csv/form_data/finisher/csv-finisher/';
        $sFinisherOption = $this->parseOption('csvFilename');
        $sFilenameFromCsv = ($sFinisherOption ? $sFinisherOption.'.csv' : 'default.csv');
//        var_dump($sFilenameFromCsv);

        $sAbsolutePathToCsvDir = $sAbsolutePathToFileadmin . $sRelativePathToCsv;
        $sAbsolutePathToCsvFile = $sAbsolutePathToFileadmin . $sRelativePathToCsv . $sFilenameFromCsv;

//        var_dump($sAbsolutePathToCsvFile);
        $formDefinition = $this->finisherContext->getFormRuntime()->getFormDefinition();

        // get raw form data
        $aRawFormData = $this->finisherContext->getFormValues();

        // build array with relevant form data only
        $aFormData = [];
        foreach ($aRawFormData as $key => $val){
            $elementsByIdentifier = $formDefinition->getElementByIdentifier($key);
            switch(true) {
                case str_contains($key, 'gridrow'):
                case str_contains($key, 'fieldset'):
                case str_contains($key, 'contentelement'):
                case $elementsByIdentifier === null:
                case $elementsByIdentifier != null && $formDefinition->getElementByIdentifier($key)->getType() === 'StaticText':
                case $elementsByIdentifier != null && $formDefinition->getElementByIdentifier($key)->getType() === 'Honeypot':
                    $wqcrwrwv = 1;
                    break;
                default:
                    $aFormData[$key] = preg_replace('!\s+!', ' ', preg_replace( "/(\r\n)|(\n)|(\t)/", " ", $val));
            }
        }

        // Add date column
        $dateTime = new DateTime('NOW');
        $aFormData['date'] = $dateTime->format('Y-m-d');

        $fs = new Filesystem();

        // build default directory initially - info: "directory existence"
        if (!$fs->exists($sAbsolutePathToCsvDir)) {
            // directory does not exist
            try {
                // try to create directory
                $fs->mkdir($sAbsolutePathToCsvDir);
            } catch (IOExceptionInterface $e) {
                return false;
            }
        }

        $sCsvContent = '';

        // generate file initially - info: "file existence"
        if (!$fs->exists($sAbsolutePathToCsvFile)) {
            // file does not exist
            try {
                // try to create file
                $fs->touch($sAbsolutePathToCsvFile);

                $sCsvContent .= implode(';', array_keys($aFormData));
                $sCsvContent .= PHP_EOL;

            } catch (IOExceptionInterface $e) {
                return false;
            }
        }

        $sCsvContent .= implode(';', $aFormData);
        $sCsvContent .= PHP_EOL;
        $sCsvContent = iconv("UTF-8", "Windows-1252", $sCsvContent);

//        var_dump($sCsvContent);die;

        $fs->appendToFile($sAbsolutePathToCsvFile, $sCsvContent);
    }
}
