<?php
namespace ZWEI14\T3template\Condition;

use TYPO3\CMS\Core\Configuration\TypoScript\ConditionMatching\AbstractCondition;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Database\Query\QueryBuilder;
use TYPO3\CMS\Core\Utility\GeneralUtility;

class LanguageModeFreeChecked extends AbstractCondition
{

    /**
     * Check if this is a local environment with a simple TypoScript condition:
     *      [In2code\Ext\Condition\IsLocalEnvironmentCondition]
     * or with a defined ip address:
     *      [In2code\Ext\Condition\IsLocalEnvironmentCondition = 127.0.0.1]
     *
     * @param array $conditionParameters
     * @return bool
     */
    public function matchCondition(array $conditionParameters)
    {
        /*if (empty($conditionParameters[0])) {
            #return GeneralUtility::getIndpEnv('REMOTE_ADDR') === '127.0.0.1';
            return false;
        } else {
            #$ipAddress = ltrim($conditionParameters[0], ' =');
            #return GeneralUtility::getIndpEnv('REMOTE_ADDR') === $ipAddress;
            return true;
        }*/

        $table = 'pages_language_overlay';
        $field = 'tx_t3template_language_mode_free';
        $pid = intval($GLOBALS['TSFE']->id);
        //$lid = intval($GLOBALS['TSFE']->sys_language_uid);
        $lid = intval($GLOBALS['_GET']['L']);
        //$aAttributes = $GLOBALS['TYPO3_REQUEST']->getAttributes();
        //$lid = intval($aAttributes['language']->getLanguageId());

        if ($lid > 0) {
            $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)
                ->getQueryBuilderForTable($table);

            $data = $queryBuilder
                ->select($field)
                ->from($table)
                ->where($queryBuilder->expr()->eq('pid', $pid))
                ->andWhere($queryBuilder->expr()->eq('sys_language_uid', $lid))
                ->execute()
                ->fetchAll();

            if (intval($data[0]['tx_t3template_language_mode_free']) == 1) {
                return true;
            } else {
                return false;
            }

            /*$result = FALSE;
            if (empty($conditionParameters)) {
                $result = TRUE;
            }
            if (!empty($conditionParameters) && $conditionParameters[0] === 'TYPO3') {
                $result = TRUE;
            }
            if (!empty($conditionParameters) && substr($conditionParameters[0], 0, 1) === '=') {
                $conditionParameters[0] = trim(substr($conditionParameters[0], 1));
                if ($conditionParameters[0] == '42') {
                    $result = TRUE;
                }
            }

            return $result;*/
        }
    }
}