<?php
declare(strict_types=1);

namespace ZWEI14\T3template\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Helper\Table;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Database\ConnectionPool;

/**
 * This task checks if the user has registered 10 Years (3650 days) ago
 */
class SendMailAfterManualApprovalCommand extends Command
{
    /**
     * Configures the current command.
     */
    protected function configure()
    {
        parent::configure();
        $this->setDescription('Send mail to user on manual approval.')
            ->addOption('bcc', null, InputOption::VALUE_OPTIONAL, 'bcc', 'marketing.group@weytec.com')
            ->addOption('from', null, InputOption::VALUE_REQUIRED, 'from', 'auto.sender@weytec.com')
            ->addOption('fromName', null, InputOption::VALUE_REQUIRED, 'fromName', 'WEY Group AG')
            ->addOption('subject', null, InputOption::VALUE_REQUIRED, 'subject EN', 'Welcome to myWEYTEC!')
            ->addOption('dry-run', null, InputOption::VALUE_NONE, 'Don`t actually send mails.');
    }

    /**
     * Executes the current command.
     *
     * This method is not abstract because you can use this class
     * as a concrete class. In this case, instead of defining the
     * execute() method, you set the code to execute by passing
     * a Closure to the setCode() method.
     *
     * @param InputInterface $input
     * @param OutputInterface $output
     *
     * @return int|null null or 0 if everything went fine, or an error code
     *
     * @throws \TYPO3\CMS\Core\Cache\Exception\NoSuchCacheException
     *
     * @see setCode()
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $dryRun = ($input->getOption('dry-run') == 1 ? true : false);

        $io = new SymfonyStyle($input, $output);

        $recipient = $input->getOption('bcc');
        $io->success('BCC: ' . $recipient);

        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('fe_users');
        $queryBuilder
            ->getRestrictions()
            ->removeAll();
        $result = $queryBuilder
            ->select('fe_users.uid','fe_users.username','fe_users.first_name','fe_users.name','fe_users.email','fe_users.mail_after_approval')
            ->from('fe_users')
            ->where(
                $queryBuilder->expr()->eq('fe_users.mail_after_manual_approval', $queryBuilder->createNamedParameter(0, \PDO::PARAM_INT)),
                $queryBuilder->expr()->eq('fe_users.disable', $queryBuilder->createNamedParameter(0, \PDO::PARAM_INT)),
                $queryBuilder->expr()->eq('fe_users.deleted', $queryBuilder->createNamedParameter(0, \PDO::PARAM_INT))
            )
            ->execute()
            ->fetchAllAssociative();

        // debug($queryBuilder->getSql());
        // die();

        if(empty($result)) {

            $io->success('Nothing to do');
            $this->appendToStderr('[SUCCESS] Nothing to do.');
            $this->writeToPhpStderr($this->getStderr());
            return 0;

        }

            $table = new Table($output);
            $tableRows = [];
            foreach ($result as $key => $values) {

                $printValues = [
                    'uid' => $values['uid'],
                    'email' => mb_substr($values['email'], 0, 3, 'UTF-8') . '...' . mb_substr($values['email'], -6, 6, 'UTF-8'),
                    'mail' => '',
                    'sent' => 'no (error)',
                ];



                if ($key === 0) {
                    $table
                        ->setHeaders(array_keys($printValues));
                }

                
                $mailBody = 'Dear ' . implode(' ', [$values['first_name'], $values['name']]) . ', 

Thank you for your interest in myWEYTEC.
Your account has been activated and you can login in at this time.

Please note that dormant myWEYTEC accounts will be deactivated after 12 months of inactivity. 
In this does occur, feel free to register for a new account.

Best regards, 
your myWEYTEC team 
 
WEY Group AG · Dorfstrasse 57 · 8103 Unterengstringen · Switzerland
www.weytec.com';
                       

                $printValues['mail'] = '...' . mb_substr($mailBody,0, 9, 'UTF-8') . '...';

                try {
                    // Create the message
                    $mail = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance(\TYPO3\CMS\Core\Mail\MailMessage::class);

                    // Prepare and send the message
                    $mail

                    // Defining the "From" email address and name as an object
                    // (email clients will display the name)
                    ->setFrom($input->getOption('from'), $input->getOption('fromName'))

                    // Set the "To" addresses
                    ->setTo(
                       $values['email'], implode(' ', [$values['first_name'], $values['name']])
                    )
                    
                    // Give the message a subject
                    ->setSubject($input->getOption('subject'))

                    // Give it the text message
                    ->addPart($mailBody)
                    ;

                    if ($input->getOption('bcc') != '') {
                        $mail->setBcc($input->getOption('bcc'), $input->getOption('fromName'));
                    }

                    $printValues['sent'] = 'no (dry-run)';
                    if( ! $dryRun) {
                        // And finally send it
                        $mail->send();
                        $printValues['sent'] = 'yes';
                    }

                    $tableRows[] = $printValues;

                    $queryBuilder
                    ->update('fe_users')
                    ->where(
                        $queryBuilder->expr()->eq('fe_users.uid', $queryBuilder->createNamedParameter($values['uid'], \PDO::PARAM_INT))
                    )
                    ->set('mail_after_manual_approval', 1)
                    ->execute();

                } catch (\Exception $e) {
                    $tableRows[] = $printValues;
                }

            }

        $table->setRows($tableRows);
        $table->render();

        $io->success('Done');
        foreach($tableRows as $row) {
            $this->appendToStderr(implode(" | ", $row));
        }
        
        $this->appendToStderr('[SUCCESS] Done.');
        $this->writeToPhpStderr($this->getStderr());
        return 0;
    }

    /**
     * @param string $value
     */
    public function appendToStderr (string $value): void {

        if ($this->stderr === '') {
            $this->stderr .= $value;
            return;
        }

        $this->stderr .= PHP_EOL . $value;

    }

    /**
     * @return string
     */
    public function getStderr(): string
    {
        return $this->stderr;
    }

    /**
     * @param string $value
     */
    public function setStderr(string $value): void
    {
        $this->stderr = $value;
    }

    /**
     * @param string $value
     */
    function writeToPhpStderr(string $value): void
    {
        $stderr = fopen('php://stderr', 'w');
        fwrite($stderr, $value);
        fclose($stderr);
    }
}
