<?php
namespace WEYTEC\WeytecEol\Evaluation;

/**
 * Class for field value validation/evaluation to be used in 'eval' of TCA
 */
class DateEvaluation
{

    private $pattern =
        '/(\d{4}-(0[1-9]|1[0-2])-(0[1-9]|1[0-9]|2[0-9]|3[0-1]))|((0[1-9]|1[0-9]|2[0-9]|3[0-1]).(0[1-9]|1[0-2]).\d{4})/';

    /**
     * JavaScript code for client side validation/evaluation
     *
     * @return string JavaScript code for client side validation/evaluation
     */
    public function returnFieldJS()
    {
        return 'return value;';
    }

    /**
     * Server-side validation/evaluation on saving the record
     *
     * @param string $value The field value to be evaluated
     * @param string $is_in The "is_in" value of the field configuration from TCA
     * @param bool $set Boolean defining if the value is written to the database or not.
     * @return string Evaluated field value
     */
    public function evaluateFieldValue($value, $is_in, &$set)
    {

        $value = preg_replace("/[^0-9\-\.]/", "", $value);

        if (preg_match($this->pattern, $value) !== 1) {
            return '';
        }

        return $value;

    }

    /**
     * Server-side validation/evaluation on opening the record
     *
     * @param array $parameters Array with key 'value' containing the field value from the database
     * @return string Evaluated field value
     */
    public function deevaluateFieldValue(array $parameters)
    {

        $parameters['value'] = preg_replace("/[^0-9\-\.]/", "", $parameters['value']);

        if (preg_match($this->pattern, $parameters['value']) !== 1) {
            return '';
        }

        return $parameters['value'];
    }
}
