<?php

$model = basename(__FILE__, '.php');

$fields = [
    'article_number',
    'article_name',
    'end_of_sale',
    'end_of_support',
    'replacement_number',
    'replacement',
    'last_update',
    'file',
];

foreach ($fields as $field) {
    $GLOBALS['TCA'][$model]['columns'][$field]['label'] =
        "LLL:EXT:weytec_eol/Resources/Private/Language/translation_db.xlf:tx_weyteceol_domain_model_product.$field";

    switch (true) {
        case $field == 'file':
            $GLOBALS['TCA'][$model]['columns'][$field]['config']['overrideChildTca'] = [
                'columns' => [
                    'uid_local' => [
                        'config' => [
                            'appearance' => [
                                'elementBrowserType' => 'file',
                                'elementBrowserAllowed' => 'pdf'
                            ],
                        ],
                    ],
                ],
            ];
            $GLOBALS['TCA'][$model]['columns'][$field]['config']['filter'] = [
                [
                    'userFunc' => 'TYPO3\\CMS\\Core\\Resource\\Filter\\FileExtensionFilter->filterInlineChildren',
                    'parameters' => [
                        'allowedFileExtensions' => 'pdf',
                        //'disallowedFileExtensions' => $disallowedFileExtensions
                    ]
                ]
            ];
            break;
        case $field == 'end_of_sale':
//        case $field == 'end_of_support':
//        case $field == 'last_update':
            $GLOBALS['TCA'][$model]['columns'][$field]['config']['eval'] = 'trim,WEYTEC\\WeytecEol\\Evaluation\\DateEvaluation,required';
            $GLOBALS['TCA'][$model]['columns'][$field]['config']['is_in'] = '1234567890-.';
            $GLOBALS['TCA'][$model]['columns'][$field]['config']['max'] = 10;
            $GLOBALS['TCA'][$model]['columns'][$field]['config']['placeholder'] = 'YYYY-MM-DD oder DD.MM.YYYY';
            break;
    }

}

$GLOBALS['TCA'][$model]['ctrl']['title'] =
    'LLL:EXT:weytec_eol/Resources/Private/Language/translation_db.xlf:tx_weyteceol_domain_model_product';

