<?php
namespace WEYTEC\WeytecEol\Domain\Model;


/***
 *
 * This file is part of the "weytec_eol" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2021 
 *
 ***/
/**
 * Product
 */
class Product extends \TYPO3\CMS\Extbase\DomainObject\AbstractEntity
{

    /**
     * articleNumber
     * 
     * @var string
     * @TYPO3\CMS\Extbase\Annotation\Validate("NotEmpty")
     */
    protected $articleNumber = '';

    /**
     * articleName
     * 
     * @var string
     * @TYPO3\CMS\Extbase\Annotation\Validate("NotEmpty")
     */
    protected $articleName = '';

    /**
     * endOfSale
     * 
     * @var string
     * @TYPO3\CMS\Extbase\Annotation\Validate("NotEmpty")
     */
    protected $endOfSale = '';

    /**
     * endOfSupport
     * 
     * @var string
     * @TYPO3\CMS\Extbase\Annotation\Validate("NotEmpty")
     */
    protected $endOfSupport = '';

    /**
     * replacementNumber
     * 
     * @var string
     */
    protected $replacementNumber = '';

    /**
     * replacement
     * 
     * @var string
     */
    protected $replacement = '';

    /**
     * lastUpdate
     * 
     * @var string
     * @TYPO3\CMS\Extbase\Annotation\Validate("NotEmpty")
     */
    protected $lastUpdate = '';

    /**
     * file
     * 
     * @var \TYPO3\CMS\Extbase\Domain\Model\FileReference
     * @TYPO3\CMS\Extbase\Annotation\ORM\Cascade("remove")
     */
    protected $file = null;

    /**
     * Returns the articleNumber
     * 
     * @return string $articleNumber
     */
    public function getArticleNumber()
    {
        return $this->articleNumber;
    }

    /**
     * Sets the articleNumber
     * 
     * @param string $articleNumber
     * @return void
     */
    public function setArticleNumber($articleNumber)
    {
        $this->articleNumber = $articleNumber;
    }

    /**
     * Returns the endOfSale
     * 
     * @return string $endOfSale
     */
    public function getEndOfSale()
    {
        return $this->endOfSale;
    }

    /**
     * Sets the endOfSale
     * 
     * @param string $endOfSale
     * @return void
     */
    public function setEndOfSale($endOfSale)
    {
        $this->endOfSale = $endOfSale;
    }

    /**
     * Returns the endOfSupport
     * 
     * @return string $endOfSupport
     */
    public function getEndOfSupport()
    {
        return $this->endOfSupport;
    }

    /**
     * Sets the endOfSupport
     * 
     * @param string $endOfSupport
     * @return void
     */
    public function setEndOfSupport($endOfSupport)
    {
        $this->endOfSupport = $endOfSupport;
    }

    /**
     * Returns the replacement
     * 
     * @return string $replacement
     */
    public function getReplacement()
    {
        return $this->replacement;
    }

    /**
     * Sets the replacement
     * 
     * @param string $replacement
     * @return void
     */
    public function setReplacement($replacement)
    {
        $this->replacement = $replacement;
    }

    /**
     * Returns the lastUpdate
     * 
     * @return string $lastUpdate
     */
    public function getLastUpdate()
    {
        return $this->lastUpdate;
    }

    /**
     * Sets the lastUpdate
     * 
     * @param string $lastUpdate
     * @return void
     */
    public function setLastUpdate($lastUpdate)
    {
        $this->lastUpdate = $lastUpdate;
    }

    /**
     * Returns the articleName
     * 
     * @return string articleName
     */
    public function getArticleName()
    {
        return $this->articleName;
    }

    /**
     * Sets the articleName
     * 
     * @param string $articleName
     * @return void
     */
    public function setArticleName($articleName)
    {
        $this->articleName = $articleName;
    }

    /**
     * Returns the replacementNumber
     * 
     * @return string $replacementNumber
     */
    public function getReplacementNumber()
    {
        return $this->replacementNumber;
    }

    /**
     * Sets the replacementNumber
     * 
     * @param string $replacementNumber
     * @return void
     */
    public function setReplacementNumber($replacementNumber)
    {
        $this->replacementNumber = $replacementNumber;
    }

    /**
     * Returns the file
     * 
     * @return \TYPO3\CMS\Extbase\Domain\Model\FileReference $file
     */
    public function getFile()
    {
        return $this->file;
    }

    /**
     * Sets the file
     * 
     * @param \TYPO3\CMS\Extbase\Domain\Model\FileReference $file
     * @return void
     */
    public function setFile(\TYPO3\CMS\Extbase\Domain\Model\FileReference $file)
    {
        $this->file = $file;
    }
}
