<?php
namespace WEYTEC\WeytecEol\Controller;


/***
 *
 * This file is part of the "weytec_eol" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2021 
 *
 ***/
/**
 * ProductController
 */
class ProductController extends \TYPO3\CMS\Extbase\Mvc\Controller\ActionController
{

    /**
     * productRepository
     * 
     * @var \WEYTEC\WeytecEol\Domain\Repository\ProductRepository
     */
    protected $productRepository = null;

    /**
     * @param \WEYTEC\WeytecEol\Domain\Repository\ProductRepository $productRepository
     */
    public function injectProductRepository(\WEYTEC\WeytecEol\Domain\Repository\ProductRepository $productRepository)
    {
        $this->productRepository = $productRepository;
    }

    /**
     * action list
     * 
     * @return void
     */
    public function listAction()
    {
        $products = $this->productRepository->findAll();
        $this->view->assign('products', $products);
    }
}
